####################################################
### code chunk number : A Real Data Example
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## 
rt<-read.table("data/bodyfat.txt", head=TRUE); rt
class(rt)
dim(rt)

x = rt$Pct.BF/100; x
range(x)
L_x = length(x); L_x
n = L_x - 1; n

## 
## Histogram
## 
dev.new()
col = c("blue")
lty = 1
hist(x, probability = TRUE, breaks = 20,
    main = paste("Histogram of" , "x"), 
    xlab = "x")
lines(density(x), lty = lty[1], col = col[1], lwd = 4)
leg.txt = c("Density estimation curve")
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/N-IG_Histogram_x", type = c("pdf"))
savePlot(filename = "figure/N-IG_Histogram_x", type = c("jpg"))


## 
## Goodness-of-fit: KS test
## 

## 
## Moment estimators
## 
mu_1_alpha_1_beta_1 = Moment_estimators(x[1:n])
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1

## ks_test
ks_test_1 = ks.test((x[1:n] - mu_1) / sqrt(beta_1 / alpha_1), "pt", 2 * alpha_1); ks_test_1
ks_test_1_ = ks.test(x[1:n], "p_N_IG_mu_alpha_beta", mu_1, alpha_1, beta_1); ks_test_1_


## Compute_Estimators_PESLs_new
source("subfunctions.R")
res_moment = Compute_Estimators_PESLs_new(mu = mu_1, alpha = alpha_1, beta = beta_1, x_np1 = x[n + 1]); res_moment

## Compute the mean and variance of the data
E_V_moment = Compute_mean_variance(mu = mu_1, alpha = alpha_1, beta = beta_1); E_V_moment


##
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
##
mu_2_alpha_2_beta_2 = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x[1:n])$root
mu_2 = mu_2_alpha_2_beta_2[1]; mu_2
alpha_2 = mu_2_alpha_2_beta_2[2]; alpha_2
beta_2 = mu_2_alpha_2_beta_2[3]; beta_2

## ks_test
ks_test_2 = ks.test((x[1:n] - mu_2) / sqrt(beta_2 / alpha_2), "pt", 2 * alpha_2); ks_test_2
ks_test_2_ = ks.test(x[1:n], "p_N_IG_mu_alpha_beta", mu_2, alpha_2, beta_2); ks_test_2_


## Compute_Estimators_PESLs_new
res_MLE = Compute_Estimators_PESLs_new(mu = mu_2, alpha = alpha_2, beta = beta_2, x_np1 = x[n + 1]); res_MLE

## Compute the mean and variance of the data
E_V_MLE = Compute_mean_variance(mu = mu_2, alpha = alpha_2, beta = beta_2); E_V_MLE

